

ext <- ".tlg";




screen_w <- 960, screen_h <- 540;
screen_hw <- screen_w/2, screen_hh <- screen_h/2;
EndFlag <- 1;
SliderWheel <- 0;



local itoa_table = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];

function i2s(i, d=1){
local s = array(10), ret = "";
if(i){
local l = 0, r = 0;
if(i < 0) s[r++] = "-", i = -i;
for(l=r; i; i/=10) s[r++] = itoa_table[i%10];
for(local n=r; n<d; n++) ret += "0";
for(r--; l<=r; r--) ret += s[r];
} else {
for(local n=0; n<d; n++) ret += "0";
}
return ret;
}

function saveTxtFile(fname, text){
local myblob = blob(text.len());
if(myblob.eos()) return;
for(local i=0; i<myblob.len(); i++)
myblob.writen(text[i], 'b');
local myfile = file(fname, "wb");
myfile.writeblob(myblob);
myfile.close();
}

function loadTxtFile(fname){
local myfile = file(fname, "rb");
local myblob = myfile.readblob(myfile.len());
if(myblob.eos()) return null;
local out = "";
for(local i=0; i<myblob.len(); i++)
out += myblob.readn('b').tochar();
myfile.close();
return out;
}

local rand_x = 123456789;
local rand_y = 362436069;
local rand_z = 521288629;
rand_seed <- 88675123;
function rand(){
local t = (rand_x ^ (rand_x << 11));
rand_x = rand_y, rand_y = rand_z, rand_z = rand_seed;
return (rand_seed = (rand_seed ^ (rand_seed >> 19)) ^ (t ^ (t >> 8)));
}



function loadJsonFile(path){
local JSONSource = loadTxtFile(path);
local compiledJSONFile = compilestring("return " + JSONSource);
return compiledJSONFile();
}

function json_escape(string){
local breaks = split(string, "\"");
local outputstring = "";
foreach(key, value in breaks){
if(0 < key) outputstring += "\\\"" + value;
else outputstring += value;
}
return outputstring;
}

function json_recurse(table, l){
local json = "";
local len = table.len();
local i = 1;
foreach(key, value in table){
for(local n=0; n<l; n++) json += "\t";
if(typeof(table) != "array") json += "\"" + key + "\": ";
switch(typeof(value)){
case "array":
json += "[\n";
json += json_recurse(value, l+1);
json += "]";
break;
case "table":
json += "{\n";
json += json_recurse(value, l+1);
json += "}";
break;
case "bool":
json += value ? "true" : "false";
break;
case "integer":
json += value;
break;
case "float":
json += value;
break;
case "null":
json += "null";
break;
case "string":
json += "\"" + json_escape(value) + "\"";
break;
default:
json += "false";
break;
}
if(i++ < len) json += ",\n";
}
json += "\n";
for(local n=0; n<l-1; n++) json += "\t";
return json;
}

function saveJsonFile(fname, table){
if(typeof(table) == "table"){
saveTxtFile(fname, "{\n" + json_recurse(table, 0) + "}");
} else if(typeof(table) == "array"){
saveTxtFile(fname, "[\n" + json_recurse(table, 0) + "]");
}
}





function systemSe(file){
if(sd_status(10)) return systemSdX(10, file);
else if(sd_status(11)) return systemSdX(11, file);
else if(sd_status(12)) return systemSdX(12, file);
else if(sd_status(13)) return systemSdX(13, file);
else if(sd_status(14)) return systemSdX(14, file);
}

function systemSdX(n, file){
sd(n, file, 0, 0, 100, 0, 1, 0);
}

function systemVo(file){
if(sd_status(15)) return systemSdX(15, file);
else if(sd_status(16)) return systemSdX(16, file);
else if(sd_status(17)) return systemSdX(17, file);
else if(sd_status(18)) return systemSdX(18, file);
else if(sd_status(19)) return systemSdX(19, file);
}

function getSystemVoFileRnad(cn, num){
local filePath = array(20), fn = 0;
filePath[0] = "vo/"+cn+"/S"+cn+getScriptString("sysVoStr")+i2s(num,2)+".ogg";
for(local n=1; n<20; n++){
filePath[n] = "vo/"+cn+"/S"+cn+getScriptString("sysVoStr")+i2s(num,2)+"_"+(n+1)+".ogg";
if(!existFile(filePath[n])){
fn = rand() % n;
break;
}
}
return filePath[fn];
}

function systemVo2(num, md, cn="", file="", st=0){

if(file != ""){
file = "vo/"+file+".ogg";
} else {
if(cn == ""){
local s_sysvo = getScriptInteger("s_sysvo"), list = array(0);
for(local n=0; n<=md; n++) if(!(s_sysvo & (1<<n))) list.append(n);
if(!list.len()) return cn;
cn = getScriptString(getScriptInteger("VoiceNum") + list[rand() % list.len()]);
if(cn == "") error(md);
}
file = getSystemVoFileRnad(cn, num);
}






sd(15, file, 0, st, 100, 0, 1, 0);

return cn;
}



function loadButton(num, file, dx, dy, sys=10, cel=2, cnt=0){
sp(num, file + ext, sys, cel);
sp_xy(num, dx, dy);
sp_cxy(num, cnt, cnt);
sp_c(num, 0, 0);
}

function loadSlider(num, folder, btnfile, barfile, dx, dy, sys=10, cel=2, numer=1, denom=1){
sp(num, folder+btnfile+ext, sys, cel);
sp(num+1, folder+barfile+ext, sys, 0);
local size0 = sp_gsz(num), size1 = sp_gsz(num+1);
sp_xy(num, dx+(size1[0]-size0[0])*numer/denom, dy+(size1[1]-size0[1])/2);
sp_cxy(num, 0, 0);
sp_c(num, 0, 0);
sp_xy(num+1, dx, dy);
sp_cxy(num+1, 0, 0);
}

function actionButtonA(btn, state, func=null, se="2", func2=null, func3=null, func4=null, func5=null){
local num = getBtn(btn);
if(num == -1) return 0;

switch(state){
case 0:
if(func3) func3(btn);
break;
case 1:
systemSe("se/sysse_01.ogg");
if(func2) func2(btn);
break;
case 2:
if(func4) func4(btn);
break;
case 3:
systemSe("se/sysse_0"+se+".ogg");
sp_l(num, 0);
sp_ae(num);
if(func5) func5(btn);
if(func) return func(btn, num);
return 1;
}
return 0;
}

function actionButton(btn, state, func=null, se="2", func2=null, func3=null){
local num = getBtn(btn);
if(num == -1) return 0;

switch(state){
case 0:
sp_l(num, 0);
if(func3) func3(btn);
if(getScriptInteger("EffectSkip") & 2) break;
sp_ac(num, 0, 250, 0, 0x110);
break;
case 1:
systemSe("se/sysse_01.ogg");
sp_l(num, sp_gcl(num)==2?1:0);
if(func2) func2(btn);
if(getScriptInteger("EffectSkip") & 2) break;
sp_c(num, 7, 0);
sp_ac(num, 0x404040, 100, 0, 0x10);
sp_ac(num, 0, 500, 0, 0x01);
sp_ac(num, 0x404040, 500, 0, 0x01);
break;
case 2:
sp_l(num, sp_gcl(num)==2?2:1);
sp_ae(num);
sp_c(num, 0, 0);
break;
case 3:
systemSe("se/sysse_0"+se+".ogg");
sp_l(num, 0);
sp_ae(num);
sp_c(num, 0, 0);
draw();
if(func) return func(btn, num);
return 1;
}
draw();
return 0;
}

function actionButton2(btn, state, func=null, se="2"){
local num = getBtn(btn);
if(num == -1) return 0;

switch(state){
case 0:
sp_l(num, 0);
if(getScriptInteger("EffectSkip") & 2) draw();
sp_ac(num, 0, 250, 0, 0x110);
break;
case 1:
systemSe("se/sysse_01.ogg");
sp_l(num, sp_gcl(num)==2?1:0);
if(getScriptInteger("EffectSkip") & 2) draw();
sp_c(num, 7, 0);
sp_ac(num, 0x404040, 100, 0, 0x10);
sp_ac(num, 0, 500, 0, 0x01);
sp_ac(num, 0x404040, 500, 0, 0x01);
break;
case 2:
if(se != "") systemSe("se/sysse_0"+se+".ogg");
sp_l(num, sp_gcl(num)==2?2:1);
sp_ae(num);
sp_c(num, 0, 0);
draw();
if(func) return func(btn, num);
return 1;
case 3:
sp_l(num, 0);
sp_ae(num);
sp_c(num, 0, 0);
break;
}
draw();
return 0;
}



function actionSlider(key, btn, state, func, dire, var, max, dfunc=null){
local num = getBtn(btn)-1;
if(num < 0) return;
if((key==0x21 || key==0x27) && state==2){
while(1){
if(max <= getScriptInteger(var)) return;
setScriptInteger(var, getScriptInteger(var)+1);
func(btn, num);
sleep(0);
if(getPushKey(0x21) || getPushKey(0x27)) draw();
else break;
}
return;
}
if((key==0x22 || key==0x25) && state==2){
while(1){
if(getScriptInteger(var) < 1) return;
setScriptInteger(var, getScriptInteger(var)-1);
func(btn, num);
sleep(0);
if(getPushKey(0x22) || getPushKey(0x25)) draw();
else break;
}
return;
}
if(1 < key) return;
switch(state){
case 0:
sp_l(num, 0);

if(getScriptInteger("EffectSkip") & 2) break;
sp_ac(num, 0, 250, 0, 0x110);
break;
case 1:
systemSe("se/sysse_01.ogg");
sp_l(num, sp_gcl(num)==2?1:0);

if(getScriptInteger("EffectSkip") & 2) break;
sp_c(num, 7, 0);
sp_ac(num, 0x404040, 100, 0, 0x10);
sp_ac(num, 0, 500, 0, 0x01);
sp_ac(num, 0x404040, 500, 0, 0x01);
break;
case 2:
sp_l(num, sp_gcl(num)==2?2:1);
sp_ae(num);
sp_c(num, 0, 0);
actionSlider2(num, btn, func, dire, var, max, dfunc);
break;
case 3:
sp_l(num, 0);
sp_ae(num);
sp_c(num, 0, 0);
break;
}
draw();
}

function actionSlider2(num, btn, func, dire, var, max, dfunc){
local xy, barX, barY, barW, barH, btnW, btnH, tmp, btnSizeH, batSize, barMax, barPos, Answer;
tmp = sp_gxy(num+1, 0, 0), barX = tmp[0], barY = tmp[1];
print(num + ", " + barX + ", " + barY + "\n");
tmp = sp_gsz(num+1), barW = tmp[0], barH = tmp[1];
tmp = sp_gsz(num),   btnW = tmp[0], btnH = tmp[1];
if(dire) btnSizeH=btnH>>1, batSize=barH-btnH, barMax=barY+batSize, barPos=barY
else btnSizeH=btnW>>1, batSize=barW-btnW, barMax=barX+batSize, barPos=barX

xy = getCursorPos()[dire] - btnSizeH;
if(barMax < xy) xy = barMax;
else if(xy < barPos) xy = barPos;
Answer = (max * (xy-barPos) + (batSize>>1)) / batSize;
local sn = getScriptInteger(var), an = Answer - sn, mn;
if(an){
if(0 < an) mn = 100 + (an>>2);
if(an < 0) mn = 100 - (an>>2);
local st = getTimer(), ot;
while(1){
ot = getTimer() - st;
if(mn <= ot) break;
Answer = sn + an * ot / mn;
if(getScriptInteger(var) != Answer){
setScriptInteger(var, Answer);
if(dire) sp_y(num, barPos + batSize * getScriptInteger(var) / max);
else sp_x(num, barPos + batSize * getScriptInteger(var) / max);
func(btn, num);
} else if(dfunc) dfunc();
draw();
}
}

while(1){
sleep(0);
if(!getPushKey(0x01) && !getPushKey(0x0D)){
SliderWheel = 1, func(btn, num), SliderWheel = 0;
draw();
break;
}
xy = getCursorPos()[dire] - btnSizeH;
if(barMax < xy) xy = barMax;
else if(xy < barPos) xy = barPos;
Answer = (max * (xy-barPos) + (batSize>>1)) / batSize;
if(getScriptInteger(var) != Answer){
setScriptInteger(var, Answer);
if(dire) sp_y(num, barPos + batSize * getScriptInteger(var) / max);
else sp_x(num, barPos + batSize * getScriptInteger(var) / max);
func(btn, num);
} else if(dfunc) dfunc();
draw();
}
}



function actionWait(time){
local st = getTimer();
while(1){
if(!getPushKey(0x01) && !getPushKey(0x02) && !getPushKey(0x0D)) return 1;
if(time < (getTimer()-st)) return 0;
sleep(0);
draw();
}
return 0;
}



function systemEffect(time, mask="", grad=0, lah=0){
if(getScriptInteger("EffectSkip") & 2){
} else if(mask == ""){
effect(1, time, 0, "", 0, lah);
} else {
effect(existStretch(mask) ? 2 : 3, time, 0, mask, grad, lah);
}
draw();
}

function systemWait(wt, win=1, click=1, ce=1){
local nt = getTimer();
if(getSkip() || (ce && (getScriptInteger("EffectSkip")&2))) return

local event, btn, key, state;
while(EndFlag){
local skip = getSkip();
if(skip & 6) return;
if(wt && (wt<=(getTimer()-nt) && (!(click&2) || skip&1))){draw(); return;}
event = eventWaitPT();
btn = event[0], key = event[1], state = event[2];
if(click && (((key==0x01 || key==0x0D) && state==3) || state==4 || ((key==0x20 || key==0x22) && state==2))){draw(); return;}
switch(btn){
case 257: setScriptInteger("stop", key), setScriptInteger("mode", state), text_lb_mode(); break;
case 261: execute_exit(state); break;
case 262: execute_aspect(); break;
case 256: draw2(); break;
case 260: draw(); return;
}
}
}



local fflag = 0, svn, svc;
function diaLog(str, fn, cn, svn1, svn2=0){
fflag = fn;
if(!getScriptInteger("ConfirmDialog"+fflag)) return 1;


svc = systemVo2(svn1, getScriptInteger("VoiceChara")-2), svn = svn2;


setCursorPos(screen_hw, screen_hh, 5);
clearBtn();

local diaLogMX = getScriptInteger("diaLogMX");
local diaLogMY = getScriptInteger("diaLogMY");
local diaLog0X = getScriptInteger("diaLog0X");
local diaLog0Y = getScriptInteger("diaLog0Y");
local diaLog1X = getScriptInteger("diaLog1X");
local diaLog1Y = getScriptInteger("diaLog1Y");
local diaLog2X = getScriptInteger("diaLog2X");
local diaLog2Y = getScriptInteger("diaLog2Y");

local x1 = 0, x2 = 0;


if(!getScriptInteger("Title") && !getScriptInteger("Replay") && fflag==11){
loadButton(3, "sys/dialog/suspend", 0, diaLog0Y+diaLogMY, 10);
sp_o(3,-1), x1 = sp_gsz(3)[0], x2 = (screen_w-x1)/2, sp_x(3, x2+diaLogMX), x1 = x1/2+2;
}


loadButton(0, "sys/dialog/yes", diaLog0X+diaLogMX-x1, diaLog0Y+diaLogMY, 10, 2, 0), sp_o(0, -1);
loadButton(1, "sys/dialog/no", diaLog1X+diaLogMX+x1, diaLog1Y+diaLogMY, 10, 2, 0), sp_o(1, -1);
loadButton(2, "sys/dialog/check0", diaLog2X+diaLogMX, diaLog2Y+diaLogMY, 10, 2, 0), sp_o(2, -1);


local file = "sys/dialog/confirm"+cn+ext;

local file2 = "sys/dialog/confirm"+cn+"_2"+ext;
if(!getScriptInteger("Title") && !getScriptInteger("Replay") && fflag==11 && existFile(file2)) file = file2;

sp(4, file, 10, 0), sp_o(4, -1), sp_xy(4, screen_hw+diaLogMX, screen_hh+diaLogMY);

if(existFile("sys/dialog/base"+ext)) sp(5, "sys/dialog/base"+ext, 10, 0), sp_o(5 ,-1);

if(diaLogMX || diaLogMY){
local time = getScriptInteger("EffectSkip")&2 ? 0 : 250;
if(sp_exist(5)) sp_a(5, 0);
draw();
sp_axy(0, diaLog0X-x1, diaLog0Y, time, 2, 0x100);
sp_axy(1, diaLog1X+x1, diaLog1Y, time, 2, 0x100);
sp_axy(2, diaLog2X, diaLog2Y, time, 2, 0x100);

if(!getScriptInteger("Title") && !getScriptInteger("Replay") && fflag==11)
sp_axy(3, x2, diaLog0Y, time, 2, 0x100);

sp_axy(4, screen_hw, screen_hh, time, 2, 0x100);
if(sp_exist(5)) sp_aa(5, 255, time, 0, 0x100);
}

systemEffect(100);

setBtn(0, 0, 0);
setBtn(1, 1, 0);
setBtn(2, 2, 0);
setBtnTool(2, "´βʾ");

if(!getScriptInteger("Title") && !getScriptInteger("Replay") && fflag==11)
setBtn(3,3,0), setBtnTool(3, "´Ӵ˴ʼ");


local event, btn, key, state;
while(EndFlag){
setMessDraw();
event = eventWait();
btn = event[0], key = event[1], state = event[2];
switch(btn){
case 0: case 3: if(key<2 && actionButton(btn, state, dialog_answer)) return 1; break;
case 1: if(key<2 && actionButton(btn, state, dialog_answer)) return 0; break;
case 2: if(key < 2) actionButton(btn, state, dialog_check); break;
case 257: setScriptInteger("stop", key), setScriptInteger("mode", state), text_lb_mode(); break;
case 262: execute_aspect(); break;
case 256: draw2(); break;
}
switch(key){
case 0x02: case 0x08: case 0x1B: if(state == 3) return dialog_answer2(); break;
case 0x20: if(state == 3) return dialog_answer(0, 0); break;
case 0x01: sleep(1); break;
}
}

return 1;
}

function dialog_answer(btn, num){
if(btn == 3) setScriptInteger("End", 1);

if(btn!=1 && svn) systemVo2(svn, getScriptInteger("VoiceChara")-2, svc);

local diaLogMX = getScriptInteger("diaLogMX"), diaLogMY = getScriptInteger("diaLogMY");
if(diaLogMX || diaLogMY){
local diaLog0X = getScriptInteger("diaLog0X"), diaLog0Y = getScriptInteger("diaLog0Y");
local diaLog1X = getScriptInteger("diaLog1X"), diaLog1Y = getScriptInteger("diaLog1Y");
local diaLog2X = getScriptInteger("diaLog2X"), diaLog2Y = getScriptInteger("diaLog2Y");
local time = getScriptInteger("EffectSkip")&2 ? 0 : 250;
sp_axy(0, diaLog0X-diaLogMX, diaLog0Y-diaLogMY, time, 2, 0x100);
sp_axy(1, diaLog1X-diaLogMX, diaLog1Y-diaLogMY, time, 2, 0x100);
sp_axy(2, diaLog2X-diaLogMX, diaLog2Y-diaLogMY, time, 2, 0x100);

if(!getScriptInteger("Title") && !getScriptInteger("Replay") && fflag==11)
sp_axy(3, (screen_w-sp_gsz(3)[0])/2-diaLogMX, diaLog0Y-diaLogMY, time, 2, 0x100);

sp_axy(4, screen_hw-diaLogMX, screen_hh-diaLogMY, time, 2, 0x100);
if(sp_exist(5)) sp_aa(5, 0, time, 0, 0x100);
}
sp_dx(0, 5, 0);
systemEffect(100);
clearBtn();
setBtnNow(-1);
return 1;
}

function dialog_answer2(){
systemSe("se/sysse_03.ogg");
dialog_answer(1, 0);
return 0;
}

function dialog_check(btn, num){
local num = getScriptInteger("ConfirmDialog"+fflag);
sp(2, "sys/dialog/check"+num+ext, 10, 2);
setScriptInteger("ConfirmDialog"+fflag, num=num^1);
setConfirmDialog(num, fflag);
if(sp_gn(40+fflag)==("sys/config/check"+(num^1)+ext) && !getScriptInteger("s_ConfigPage"))
sp(40+fflag, "sys/config/check"+num+ext, 10, 2);
}



function VO2(file){
local play = array(10), vol = array(10);
local VoiceMobu1 = getScriptInteger("VoiceMobu1");
local VoiceMobu2 = getScriptInteger("VoiceMobu2");

for(local n=0; n<10; n++){
if(file[n] == ""){play[n] = 0; continue;}
local ns = file[n].slice(1, 4), ni = ns.tointeger();
local path = "vo/" + ns + "/" + file[n] + ".ogg";
if(VoiceMobu1 < ni) ni = VoiceMobu2+ni/300, ns = getScriptString(ni);
vol[n] = getScriptInteger("s_v"+ns) * getScriptInteger("s_m"+ns);
if(!vol[n]){play[n] = 0; continue;}








play[n] = 1, sd_load(20+n, path);

}
for(local n=0; n<10; n++){
if(play[n]) sd_play(20+n, 0, vol[n], 0, 1, 0);
else sd_stop(20+n, 0, 0);
}
}

function text_lb_voice2(){
local vct = split(getTagLog(0), ",");
local file = array(10, "");
for(local n=1; n<vct.len(); n++) file[n-1] = vct[n];
VO2(file);
}

function text_lb_voice(){
if(!(getSkip() & 1)) text_lb_voice2();
}

function mode_stop2(){


local spMode = getScriptInteger("spMode");
sp_a(spMode+0, 0), sp_a(spMode+1, 0), sp_a(spMode+2,0);








}

function mode_stop(){
setSkip(0), setAuto(0), stopMode();
mode_stop2();
}

function text_lb_mode(){
local mode = getScriptInteger("mode"), stop = getScriptInteger("stop");
if(mode&2 && getScriptInteger("VoiceCancel")) for(local n=0; n<10; n++) sd_stop(20+n, 0, 0);







setScriptInteger("mode", mode-1);

local spMode = getScriptInteger("spMode");
if(mode) sp_a(spMode+mode, 255), sp_a(spMode+1-mode, 0);

if(!mode) mode_stop2();

draw();
if(stop & 2) lookahead(), text_lb_voice2();
}



function pageEnd(win){
clearBtn(), setBtnNow(-1), setPosition((getScriptInteger("Title")||getScriptInteger("Replay")) ? 1 : 0);
sd_stop(10, 250, 0), sd_stop(15, 250, 0);
systemEffect(250);
setMessLog(getScriptInteger("strMes0WN"), getScriptInteger("strMes0HN"), 24, 24, 0, 12);
saveSetting(), saveAlready();
if(getScriptInteger("Title") || !win) return;
local spSlct = getScriptInteger("spSlct");
if(sp_exist(spSlct) && sp_gn(spSlct+1)!="sys/window/selectbar"+ext) return;
local color = [0xFFFFFF, 0xC0C0C0];
local flag = 2 + 2*(getScriptString(52)=="*select2_lb2" ? 1 : 0);
for(local n=0,m=getScriptInteger(120); n<m; n++){
if(!sp_exist(spSlct + flag*n)) break;
local c = variableExist("$s_"+getScriptString(110+n).slice(1));
if(getScriptInteger(100+n))
ssp_set(getScriptString("FontFile"), getScriptInteger("SelectSize"), getScriptInteger("FontStyle"), color[c], color[c], 0x000000);
else ssp_set(getScriptString("FontFile"), getScriptInteger("SelectSize"), getScriptInteger("FontStyle"), 0x808080, 0x808080, 0x000000);
if(flag>>2) logsp_reset(spSlct + 4*n);
else ssp_reset(spSlct + 2*n);
}
setWindowVisible(getScriptInteger("g_Visible"));
resetMess();
local vct = split(getTagLog(0), ",");
setScriptString(0, vct[0]);
if(1<vct.len()) setScriptString(10, vct[1]);
}



function execute_title(btn, num){
if(diaLog("^Cgɖ߂܂H", 10, 10, 27)){
if(getScriptInteger("Replay")){
setScriptInteger("Replay", 0);
local spMenuS = getScriptInteger("spMenuS");
for(local n=7; n<11; n++)sp_a(spMenuS+n, 255);
} else {
makeSave();
saveSave(999, 1);
}
if(existSave(998, 1)) deleteSave(998, 1);
saveSetting();
saveAlready();
return 1;
}
return 0;
}

function execute_replay(btn, num){
if(diaLog("Ҫر⣿", 10, 12, 33)){
if(getScriptInteger("Replay")){
setScriptInteger("Replay", 0);
local spMenuS = getScriptInteger("spMenuS");
for(local n=7; n<11; n++)sp_a(spMenuS+n, 255);
}
return 1;
}
return 0;
}

function execute_event(btn, num){
if(diaLog("ػģʽ", 10, 13, 33)){
if(getScriptInteger("Replay")){
setScriptInteger("Replay", 0);
local spMenuS = getScriptInteger("spMenuS");
for(local n=7; n<11; n++)sp_a(spMenuS+n, 255);
}
return 1;
}
return 0;
}

function execute_exit1(btn, num){
if(getScriptInteger("Terminate") || !getScriptInteger("ConfirmDialog11") || confirm("")){
EndFlag = 0;
return 1;
}
return 0;
}

function execute_exit0(btn, num){
if(getScriptInteger("Terminate") || diaLog("", 11, 11, 28, 29)){
EndFlag = 0;
return 1;
}
return 0;
}

function execute_exit(flag){
return flag ? execute_exit1(0,0) : execute_exit0(0,0);
}

function sound_clear(t){
for(local n=0; n<10; n++) sd_stop(n, t, 0);



for(local n=20; n<30; n++) sd_stop(n, t, 0);
}

function execute_clear(t){
clearBtn();
setWindowVisible(0);
sound_clear(t);
sp_dx(0, 399, 0);
sp_dx(getScriptInteger("spSlct"), getScriptInteger("spSlct")+21, 0);

execute_clear3(t);
}

function execute_clear3(t){
setScriptInteger("g_tc1", 0), setScriptInteger("g_tc2", 0);
setScriptInteger("g_sx", 0), setScriptInteger("g_sy", 0);
setScriptInteger("g_sw", 100), setScriptInteger("g_sh", 100);
for(local n=900, m=getScriptInteger("EndSp")+1; n<m; n++)
sp_gray(n, 0), sp_neg(n, 0), sp_rot(n, 0), sp_color(n, 0, 0, 0), sp_blur(n, 0, 0), sp_mosaic(n, 0, 0), sp_hsl(n, 0, 0, 0);
sp_gray(998, 0), sp_neg(998, 0), sp_rot(998, 0), sp_color(998, 0, 0, 0), sp_blur(998, 0, 0), sp_mosaic(998, 0, 0), sp_hsl(998, 0, 0, 0);
local spFace = getScriptInteger("spFace");
sp_gray(spFace, 0), sp_neg(spFace, 0), sp_color(spFace, 0, 0, 0), sp_blur(spFace, 0, 0), sp_mosaic(spFace, 0, 0), sp_hsl(spFace, 0, 0, 0);
sp_d(791, 0);
sp_dx(getScriptInteger("EmoSp"), getScriptInteger("EndSp"), 0);
sp_d(997, 0);
sp(998, "bg/BLACK"+ext, 2, 0);
sp_c(998, 0, 0);
sp_xy(998, screen_hw, screen_hh);
sp_wh(998, 100, 100);
sp_rxyz(998, 0, 0, 0);
sp_qx(998, 0, 0, 0, 0, 0, 0);
sp_qy(998, 0, 0, 0, 0, 0, 0);
sc_xy(0, 0, 0, 0, 0);
sc_wh(100, 100, 0, 0, 0);
sc_qx(0, 0, 0, 0, 0, 0, 0);
sc_qy(0, 0, 0, 0, 0, 0, 0);
systemEffect(t);
}

function MW_MD0(){getScriptInteger("strMes0HN")
setMessLine(getScriptInteger("strMes0N0"), getScriptInteger("strMes0N1"));
setMessIndent(getScriptInteger("strMes0I0"), getScriptInteger("strMes0I1"));
setMessXY(getScriptInteger("strMes0X"), getScriptInteger("strMes0Y"));
setMessWH(getScriptInteger("strMes0WN"), getScriptInteger("strMes0HN"), getScriptInteger("strMes0WH"), getScriptInteger("strMes0WH"), getScriptInteger("strMes0IW"), getScriptInteger("strMes0IH"));
setScriptInteger("g_Visible", 3);
}

function MW_MD1(){
setMessLine(getScriptInteger("strMes1N0"), getScriptInteger("strMes1N1"));
setMessIndent(getScriptInteger("strMes1I0"), getScriptInteger("strMes1I1"));
setMessXY(getScriptInteger("strMes1X"), getScriptInteger("strMes1Y"));
setMessWH(getScriptInteger("strMes1WN"), getScriptInteger("strMes1HN"), getScriptInteger("strMes1WH"), getScriptInteger("strMes1WH"), getScriptInteger("strMes1IW"), getScriptInteger("strMes1IH"));
setScriptInteger("g_Visible", 2);
}

function execute_clear2(){
MW_MD0();
if(getScriptInteger("g_TextSize")) setScriptInteger("g_TextSize", 0), setMessWH(getScriptInteger("strMes0WN"), getScriptInteger("strMes0HN"), getScriptInteger("strMes0WH"), getScriptInteger("strMes0WH"), getScriptInteger("strMes0IW"), getScriptInteger("strMes0IH"));
if(getScriptInteger("g_TextSpeed")) setScriptInteger("g_TextSpeed", 0), setMessSpeed(-1, -1);

sp_a(getScriptInteger("spFace"), 0);
setScriptString("g_FaceXY", "");

sp_a(getScriptInteger("spIcon"), 0);




sp_a(getScriptInteger("strName"), 0), draw3();

}

function execute_load2(n){
setScriptInteger("Title", 0);
setPosition(0);
execute_clear2();
loadSave(n, 1);
}


function execute_load(n){
execute_clear(500);
execute_load2(n);
}

function execute_save(n){
saveSave(n, 1);

saveScreenShot(getScriptString("cwd")+"save/data"+i2s(n,3)+ext,3,24,1,0);



}

function execute_wall(){
if(!getScreenAspect2()) return 0;
local spWall = getScriptInteger("spWall");
local WallPaperFile = getScriptString("WallPaperFile");
local ScreenAspect = getScreenAspect();
setScriptInteger("ScreenAspect", ScreenAspect);
if(!ScreenAspect){
sp_d(spWall, 0);
} else if(WallPaperFile == ""){
sp(spWall,"sys/window/wall2"+ext, 14, 0);
sp_b(spWall, 0);
sp_y(spWall, 630);
} else {
sp(spWall, "sys/window/"+getBaseName(WallPaperFile)+ext, 14, 0);
sp_b(spWall, 0);
sp_y(spWall, 630);
}
return ScreenAspect;
}

function execute_aspect(){
local ScreenAspect = execute_wall();

local s_Menu = getScriptInteger("s_Menu");
local spMenuS = getScriptInteger("spMenuS");
local ah = ScreenAspect ? 180 : 0, wh = ah;


local sw, mh;
if(s_Menu==2 && ScreenAspect) wh=180, mh=180, sw=0
else if(s_Menu==2 && !ScreenAspect) wh=getScriptInteger("spBerH"), mh=0, sw=0
else if((s_Menu&1) && ScreenAspect) wh=180, mh=180, sw=0
else if((s_Menu&1) && !ScreenAspect) wh=0, mh=0, sw=0
else if(!(s_Menu&1) && ScreenAspect) wh=180, mh=screen_h-getScriptInteger("spBer1Y")+180, sw=screen_w-getScriptInteger("spBer2X")
else if(!(s_Menu&1) && !ScreenAspect) wh=getScriptInteger("spBerH"), mh=screen_h-getScriptInteger("spBer1Y"), sw=screen_w-getScriptInteger("spBer2X")
















sp_xy(spMenuS+0, getScriptInteger("spBtn00X"), getScriptInteger("spBtn00Y")+mh);
sp_xy(spMenuS+1, getScriptInteger("spBtn01X"), getScriptInteger("spBtn01Y")+mh);
sp_xy(spMenuS+2, getScriptInteger("spBtn02X"), getScriptInteger("spBtn02Y")+mh);
sp_xy(spMenuS+3, getScriptInteger("spBtn03X"), getScriptInteger("spBtn03Y")+mh);
sp_xy(spMenuS+4, getScriptInteger("spBtn04X"), getScriptInteger("spBtn04Y")+mh);
sp_xy(spMenuS+5, getScriptInteger("spBtn05X"), getScriptInteger("spBtn05Y")+mh);
sp_xy(spMenuS+6, getScriptInteger("spBtn06X"), getScriptInteger("spBtn06Y")+mh);

sp_xy(spMenuS+12, getScriptInteger("spBtn12X"), getScriptInteger("spBtn12Y")+mh);

sp_xy(spMenuS+7, getScriptInteger("spBtn07X"), getScriptInteger("spBtn07Y")+mh);
sp_xy(spMenuS+8, getScriptInteger("spBtn08X"), getScriptInteger("spBtn08Y")+mh);
sp_xy(spMenuS+9, getScriptInteger("spBtn09X"), getScriptInteger("spBtn09Y")+mh);
sp_xy(spMenuS+10, getScriptInteger("spBtn10X"), getScriptInteger("spBtn10Y")+mh);
sp_xy(spMenuS+11, getScriptInteger("spBtn11X"), getScriptInteger("spBtn11Y")+mh);



sp_xy(spMenuS+16, getScriptInteger("spBer1X"), getScriptInteger("spBer1Y")+mh);





















sp_xy(getScriptInteger("spAlr"), getScriptInteger("spReadX"), getScriptInteger("spReadY")+wh);

sp_xy(getScriptInteger("spMode")+0, getScriptInteger("spModeX"), getScriptInteger("spModeY")+wh);
sp_xy(getScriptInteger("spMode")+1, getScriptInteger("spModeX"), getScriptInteger("spModeY")+wh);
sp_xy(getScriptInteger("spMode")+2, getScriptInteger("spModeX"), getScriptInteger("spModeY")+wh);


sp_xy(getScriptInteger("spIcon"), getScriptInteger("spIconX"), getScriptInteger("spIconY")+wh);

setMessSXY(0, wh);

sp_xy(getScriptInteger("strName"), getScriptInteger("strNameX"), getScriptInteger("strNameY")+wh);

sp_xy(getScriptInteger("spFace"), getScriptInteger("spFaceX"), getScriptInteger("spFaceY")+ah);

sp_xy(getScriptInteger("spWin0"), getScriptInteger("spWin00X"), getScriptInteger("spWin00Y")+wh);
sp_xy(getScriptInteger("spWin0")+1, getScriptInteger("spWin01X"), getScriptInteger("spWin01Y")+wh);





sp_xy(getScriptInteger("spWin1"), getScriptInteger("spWin10X"), getScriptInteger("spWin10Y")+wh);
sp_xy(getScriptInteger("spWin1")+1, getScriptInteger("spWin11X"), getScriptInteger("spWin11Y")+wh);





draw();
}




local spSlct = 360;
function select(str){
local vct = split(str, ",");
local selend = spSlct + vct.len()*2;
sp(spSlct, "sys/select/sdbar"+ext, 11, 3);
local barsize = sp_gsz(spSlct);
sp(selend, "sys/select/select"+ext, 15, 0);
local selsize = sp_gsz(selend);
local h = (screen_h - selsize[1]) / 2;

ssp_set("lr SVbN", 28, 22, 0xFFFFFF, 0xFFFFFF, 0x000000);
for(local n=0; n<vct.len(); n++){
local selh = h +(selsize[1]-barsize[1]*vct.len()) / (vct.len()+1) * (n+1) + barsize[1] * (n+0.5);
ssp(spSlct+2*n, vct[n], 10);
sp_xy(spSlct+2*n, screen_hw, selh.tointeger());
loadButton(spSlct+1+2*n, "sys/select/sdbar", screen_hw, selh.tointeger(), 10, 4, 1);
setBtn(1+n, spSlct+1+2*n, 0);
}

effect(1, 250, 0, "", 0, 0);

local event, btn, key, state;
while(EndFlag){
event = eventWait();
btn = event[0], key = event[1], state = event[2];
if(1<=btn && btn<=vct.len() && key<2){
if(actionButton(btn, state, function(g){return g;})){
clearBtn();
sp_dx(spSlct, selend, 1);
effect(1, 250, 0, "", 0, 0);
return btn;
}
}
switch(btn){
case 256:
draw();
break;
case 261:
execute_exit(state);
break;
}
}

clearBtn();
sp_dx(spSlct, selend, 1);
return 0;
}


function WA(time=0, win=1, click=1){
if(win) setWindowVisible(0);
local st = getTimer();
local event, btn, key, state;
while(EndFlag){
event = eventWaitPT();
btn = event[0], key = event[1], state = event[2];
if(click && (((key==0x01 || key==0x0D) && state==3) || state==4 || ((key==0x20 || key==0x22) && state==2))) return;

if(getSkip()) return;
if(time <= (getTimer()-st)) return;
if(btn == 261) execute_exit(state);
if(btn == 256) draw();
}
}



function infoEnq(html, text, game){
text = loadTxtFile(text);
local vct = regexp_split(text, "/\r\n/"), etc = "", gpu = "";

html = regexp_replace(html, "s/!Game!/"+game+"/kg");
for(local n=0; n<vct.len(); n++){
local cn = regexp_split(vct[n], "/Description /");
if(1 < cn.len()){ gpu = cn[1]; break; }
}
for(local n=0; n<vct.len(); n++){
local cn = regexp_split(vct[n], "/ : /");
if(cn[0] ==    "OS") html = regexp_replace(html, "s^!OS!^"+cn[1]+"^k");
else if(cn[0] ==   "CPU") html = regexp_replace(html, "s^!CPU!^"+cn[1]+"^k");
else if(cn[0] == "Memoy") html = regexp_replace(html, "s^!Memoy!^"+split(cn[1],"/")[1]+"^k");
else if(cn[0] ==   "GPU"){
if(cn[1] == gpu) html = regexp_replace(html, "s^!GPU!^"+cn[1]+"^k");
else n += 3;
}
else if(cn[0] ==  "VRAM") html = regexp_replace(html, "s^!VRAM!^"+cn[1]+"^k");
else if(cn[0] ==  "Mode") html = regexp_replace(html, "s^!Display!^"+cn[1]+"^k");
else if(cn[0] ==   "UID") html = regexp_replace(html, "s^!UID!^"+cn[1]+"^k");
}
etc += getFullScreen() ? "ȫ " : " ";
etc += getScreenAspect() ? "4:3 " : "16:9 ";
etc += getScreenWidth()+"x"+getScreenHeight();
html = regexp_replace(html, "s^!ETC!^"+etc+"^k");

local cwd = getScriptString("cwd");
saveTxtFile(cwd+"enquete.html", html);
shellExecute(cwd+"enquete.html","");
sleep(2000);
deleteFile(cwd+"enquete.html");
}


