﻿# Copyright Aram Ryu
#

init -1500 python in steamapi:
    from store import renpy, config

    def is_initialized():
        return False

    try:
        import _renpysteam as steam
        renpy.write_log("STEAMAPI - Steam Import Success")
    except Exception as e:
        steam = None
        renpy.write_log("STEAMAPI - Steam Import Failed: %r", e)

    if steam is not None:

        want_version = 2

        if steam.version < want_version:
            raise Exception("Steam Module Too Old (requires version %d, got %d)" % (steam.version, want_version))

        if steam.init():
            renpy.write_log("STEAMAPI - Steam Initialization Success")
            steamapi = steam
            is_initialized = True
        else:
            renpy.write_log("STEAMAPI - Steam Initialization Failed")
            steam = None

    def is_steam_on():
        if steam is not None:
            return True

        else:
            return False

    def get_persona_name():
        if steam is not None:
            return steam.get_persona_name()

        else:
            return "-"

    def is_subscribed_app(appid):
        if steam is not None:
            return steam.is_subscribed_app(appid)

        else:
            return False

    def dlc_installed(appid):
        if steam is not None:
            return steam.dlc_installed(appid)
        else:
            return False

    def install_dlc(appid):
        if steam is not None:
            return steam.install_dlc(appid)
 
    def get_progress(appid):
        if steam is not None:
            return steam.dlc_progress(appid)
        else:
            return None

    def uninstall_dlc(appid):
        if steam is not None:
            return steam.uninstall_dlc(appid)

    def get_unlock(chname):
        if steam is not None:
            return steam.get_achievement(chname)

    def set_unlock(chname):
        if steam is not None:
            return steam.grant_achievement(chname)

    def store_stats():
        if steam is not None:
            return steam.store_stats()

    def activate_overlay(dialog):
        if steam is not None:
            steam.activate_overlay(dialog)

    def activate_overlay_to_web_page(url):
        if steam is not None:
            steam.activate_overlay_to_web_page(url)

    def activate_overlay_to_store(appid, flag):
        if steam is not None:
            if flag == "cart":
                steam.activate_overlay_to_store(appid, steam.STORE_ADD_TO_CART_AND_SHOW)

            else:
                steam.activate_overlay_to_store(appid, steam.STORE_NONE)
